/*
 * Decompiled with CFR 0.152.
 */
package com.gojuno.hexgrid;

import com.gojuno.hexgrid.Hex;

public class FractionalHex {
    private double q;
    private double r;

    public FractionalHex(double q, double r) {
        this.q = q;
        this.r = r;
    }

    public double getQ() {
        return this.q;
    }

    public double getR() {
        return this.r;
    }

    public double getS() {
        return -(this.q + this.r);
    }

    public Hex toHex() {
        long q = Math.round(this.getQ());
        long r = Math.round(this.getR());
        long s = Math.round(this.getS());
        double qDiff = Math.abs((double)q - this.getQ());
        double rDiff = Math.abs((double)r - this.getR());
        double sDiff = Math.abs((double)s - this.getS());
        if (qDiff > rDiff && qDiff > sDiff) {
            q = -(r + s);
        } else if (rDiff > sDiff) {
            r = -(q + s);
        }
        return new Hex(q, r);
    }

    public String toString() {
        return String.format("fraction_hex{q: %d, r: %d}", this.q, this.r);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!FractionalHex.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        FractionalHex other = (FractionalHex)obj;
        return other.q == this.q && other.r == this.r;
    }
}

