/*
 * Decompiled with CFR 0.152.
 */
package com.gojuno.hexgrid;

import com.gojuno.hexgrid.FractionalHex;
import com.gojuno.hexgrid.Hex;
import com.gojuno.hexgrid.Orientation;
import com.gojuno.hexgrid.Point;
import com.gojuno.hexgrid.Region;
import com.gojuno.morton.Morton64;

public class HexGrid {
    private Orientation orientation;
    private Point origin;
    private Point size;
    private Morton64 mort;

    public HexGrid(Orientation orientation, Point origin, Point size, Morton64 mort) {
        this.orientation = orientation;
        this.origin = origin;
        this.size = size;
        this.mort = mort;
    }

    public long hexToCode(Hex hex) {
        return this.mort.spack(new long[]{hex.getQ(), hex.getR()});
    }

    public Hex hexFromCode(long code) {
        long[] qr = this.mort.sunpack(code);
        return new Hex(qr[0], qr[1]);
    }

    public Hex hexAt(Point point) {
        double x = (point.getX() - this.origin.getX()) / this.size.getX();
        double y = (point.getY() - this.origin.getY()) / this.size.getY();
        double q = this.orientation.getB()[0] * x + this.orientation.getB()[1] * y;
        double r = this.orientation.getB()[2] * x + this.orientation.getB()[3] * y;
        return new FractionalHex(q, r).toHex();
    }

    public Point hexCenter(Hex hex) {
        double x = (this.orientation.getF()[0] * (double)hex.getQ() + this.orientation.getF()[1] * (double)hex.getR()) * this.size.getX() + this.origin.getX();
        double y = (this.orientation.getF()[2] * (double)hex.getQ() + this.orientation.getF()[3] * (double)hex.getR()) * this.size.getY() + this.origin.getY();
        return new Point(x, y);
    }

    public Point[] hexCorners(Hex hex) {
        Point[] corners = new Point[6];
        Point center = this.hexCenter(hex);
        for (int i = 0; i < 6; ++i) {
            double x = this.size.getX() * this.orientation.getCosinuses()[i] + center.getX();
            double y = this.size.getY() * this.orientation.getSinuses()[i] + center.getY();
            corners[i] = new Point(x, y);
        }
        return corners;
    }

    public Hex[] hexNeighbors(Hex hex, int layers) {
        int total = (layers + 1) * layers * 3;
        Hex[] neighbors = new Hex[total];
        int i = 0;
        for (long q = (long)(-layers); q <= (long)layers; ++q) {
            long r1 = Math.max((long)(-layers), -q - (long)layers);
            long r2 = Math.min((long)layers, -q + (long)layers);
            for (long r = r1; r <= r2; ++r) {
                if (q == 0L && r == 0L) continue;
                neighbors[i] = new Hex(q + hex.getQ(), r + hex.getR());
                ++i;
            }
        }
        return neighbors;
    }

    public Region createRegion(Point[] geometry) {
        return new Region(this, geometry);
    }

    public String toString() {
        return String.format("hexgrid{orientation: %s, origin: %s, size: %s, mort: %s}", this.orientation.toString(), this.origin.toString(), this.size.toString(), this.mort.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!HexGrid.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        HexGrid other = (HexGrid)obj;
        return other.orientation.equals(this.orientation) && other.origin.equals(this.origin) && other.size.equals(this.size) && other.mort.equals((Object)this.mort);
    }
}

