/*
 * Decompiled with CFR 0.152.
 */
package com.gojuno.hexgrid;

import java.util.Arrays;

public class Orientation {
    public static final Orientation POINTY = new Orientation("pointy", new double[]{Math.sqrt(3.0), Math.sqrt(3.0) / 2.0, 0.0, 1.5}, new double[]{Math.sqrt(3.0) / 3.0, -0.3333333333333333, 0.0, 0.6666666666666666}, 0.5);
    public static final Orientation FLAT = new Orientation("flat", new double[]{1.5, 0.0, Math.sqrt(3.0) / 2.0, Math.sqrt(3.0)}, new double[]{0.6666666666666666, 0.0, -0.3333333333333333, Math.sqrt(3.0) / 3.0}, 0.0);
    private String name;
    private double[] f;
    private double[] b;
    private double startAngle;
    private double[] sinuses;
    private double[] consinuses;

    public Orientation(String name, double[] f, double[] b, double startAngle) {
        this.name = name;
        this.f = f;
        this.b = b;
        this.startAngle = startAngle;
        this.prehashAngles();
    }

    public double[] getF() {
        return this.f;
    }

    public double[] getB() {
        return this.b;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double[] getSinuses() {
        return this.sinuses;
    }

    public double[] getCosinuses() {
        return this.consinuses;
    }

    private void prehashAngles() {
        this.sinuses = new double[6];
        this.consinuses = new double[6];
        for (int i = 0; i < 6; ++i) {
            double angle = Math.PI * 2 * ((double)i + this.getStartAngle()) / 6.0;
            this.sinuses[i] = Math.sin(angle);
            this.consinuses[i] = Math.cos(angle);
        }
    }

    public String toString() {
        return String.format("orientation{name: %s}", this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!Orientation.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Orientation other = (Orientation)obj;
        return other.name.equals(this.name) && Arrays.equals(other.f, this.f) && Arrays.equals(other.b, this.b);
    }
}

