/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.bag.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.bag.MutableBag;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatBag extends MutableFloatCollection, FloatBag
{
    void addOccurrences(float item, int occurrences);

    boolean removeOccurrences(float item, int occurrences);

    MutableFloatBag select(FloatPredicate predicate);

    MutableFloatBag reject(FloatPredicate predicate);

    <V> MutableBag<V> collect(FloatToObjectFunction<? extends V> function);

    MutableFloatBag with(float element);

    MutableFloatBag without(float element);

    MutableFloatBag withAll(FloatIterable elements);

    MutableFloatBag withoutAll(FloatIterable elements);

    MutableFloatBag asUnmodifiable();

    MutableFloatBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableFloatBag toImmutable();
}
