/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableCharObjectMap;
import com.gs.collections.api.map.primitive.CharObjectMap;

/**
 * A factory which creates instances of type {@link ImmutableCharObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableCharObjectMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    <V> ImmutableCharObjectMap<V> of();

    <V> ImmutableCharObjectMap<V> with();

    /**
     * Same as {@link #with(char, Object)}.
     */
    <V> ImmutableCharObjectMap<V> of(char key, V value);

    <V> ImmutableCharObjectMap<V> with(char key, V value);

    /**
     * Same as {@link #withAll(CharObjectMap)}.
     */
    <V> ImmutableCharObjectMap<V> ofAll(CharObjectMap<? extends V>  map);

    <V> ImmutableCharObjectMap<V> withAll(CharObjectMap<? extends V>  map);
}
