/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableShortShortMap;
import com.gs.collections.api.map.primitive.ShortShortMap;

/**
 * A factory which creates instances of type {@link ImmutableShortShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableShortShortMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableShortShortMap of();

    ImmutableShortShortMap with();

    /**
     * Same as {@link #with(short, short)}.
     */
    ImmutableShortShortMap of(short key, short value);

    ImmutableShortShortMap with(short key, short value);

    /**
     * Same as {@link #withAll(ShortShortMap)}.
     */
    ImmutableShortShortMap ofAll(ShortShortMap map);

    ImmutableShortShortMap withAll(ShortShortMap map);
}
