/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableBooleanList extends ImmutableBooleanCollection, BooleanList
{
    ImmutableBooleanList select(BooleanPredicate predicate);

    ImmutableBooleanList reject(BooleanPredicate predicate);

    <V> ImmutableList<V> collect(BooleanToObjectFunction<? extends V> function);

    ImmutableBooleanList newWith(boolean element);

    ImmutableBooleanList newWithout(boolean element);

    ImmutableBooleanList newWithAll(BooleanIterable elements);

    ImmutableBooleanList newWithoutAll(BooleanIterable elements);

    ImmutableBooleanList toReversed();

    ImmutableBooleanList subList(int fromIndex, int toIndex);
}
