/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.DoubleObjectPredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;

/**
 * This file was automatically generated from template file immutablePrimitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleObjectMap<V> extends DoubleObjectMap<V>
{
    ImmutableDoubleObjectMap<V> select(DoubleObjectPredicate<? super V> predicate);

    ImmutableDoubleObjectMap<V> reject(DoubleObjectPredicate<? super V> predicate);

    ImmutableCollection<V> select(Predicate<? super V> predicate);

    <P> ImmutableCollection<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter);

    ImmutableCollection<V> reject(Predicate<? super V> predicate);

    <VV> ImmutableCollection<VV> collect(Function<? super V, ? extends VV> function);

    ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction);

    ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction);

    ImmutableCharCollection collectChar(CharFunction<? super V> charFunction);

    ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction);

    ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction);

    ImmutableIntCollection collectInt(IntFunction<? super V> intFunction);

    ImmutableLongCollection collectLong(LongFunction<? super V> longFunction);

    ImmutableShortCollection collectShort(ShortFunction<? super V> ShortFunction);

    <P, VV> ImmutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter);

    ImmutableDoubleObjectMap<V> newWithKeyValue(double key, V value);

    ImmutableDoubleObjectMap<V> newWithoutKey(double key);

    ImmutableDoubleObjectMap<V> newWithoutAllKeys(DoubleIterable keys);
}
