/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.function.primitive.DoubleToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleFloatPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleFloatMap extends DoubleFloatMap
{
    void clear();

    void put(double key, float value);

    void putAll(DoubleFloatMap map);

    void removeKey(double key);

    void remove(double key);

    float removeKeyIfAbsent(double key, float value);

    float getIfAbsentPut(double key, float value);

    float getIfAbsentPut(double key, FloatFunction0 function);

    float getIfAbsentPutWithKey(double key, DoubleToFloatFunction function);

    <P> float getIfAbsentPutWith(double key, FloatFunction<? super P> function, P parameter);

    float updateValue(double key, float initialValueIfAbsent, FloatToFloatFunction function);

    MutableDoubleFloatMap select(DoubleFloatPredicate predicate);

    MutableDoubleFloatMap reject(DoubleFloatPredicate predicate);

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableDoubleFloatMap withKeyValue(double key, float value);

    MutableDoubleFloatMap withoutKey(double key);

    MutableDoubleFloatMap withoutAllKeys(DoubleIterable keys);

    MutableDoubleFloatMap asUnmodifiable();

    MutableDoubleFloatMap asSynchronized();

    float addToValue(double key, float toBeAdded);
}
