/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectDoubleMap<K> extends ObjectDoubleMap<K>
{
    void clear();

    void put(K key, double value);

    void putAll(ObjectDoubleMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    double removeKeyIfAbsent(K key, double value);

    double getIfAbsentPut(K key, double value);

    double getIfAbsentPut(K key, DoubleFunction0 function);

    double getIfAbsentPutWithKey(K key, DoubleFunction<? super K> function);

    <P> double getIfAbsentPutWith(K key, DoubleFunction<? super P> function, P parameter);

    double updateValue(K key, double initialValueIfAbsent, DoubleToDoubleFunction function);

    MutableObjectDoubleMap<K> select(ObjectDoublePredicate<? super K> predicate);

    MutableObjectDoubleMap<K> reject(ObjectDoublePredicate<? super K> predicate);

    MutableDoubleCollection select(DoublePredicate predicate);

    MutableDoubleCollection reject(DoublePredicate predicate);

    <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableObjectDoubleMap<K> withKeyValue(K key, double value);

    MutableObjectDoubleMap<K> withoutKey(K key);

    MutableObjectDoubleMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectDoubleMap<K> asUnmodifiable();

    MutableObjectDoubleMap<K> asSynchronized();

    double addToValue(K key, double toBeAdded);
}
