/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import java.util.Set;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.predicate.primitive.ObjectIntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.tuple.primitive.ObjectIntPair;

/**
 * This file was automatically generated from template file objectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ObjectIntMap<K> extends IntIterable
{
    int get(Object key);

    int getOrThrow(Object key);

    int getIfAbsent(Object key, int ifAbsent);

    boolean containsKey(Object key);

    boolean containsValue(int value);

    void forEachValue(IntProcedure procedure);

    void forEachKey(Procedure<? super K> procedure);

    void forEachKeyValue(ObjectIntProcedure<? super K> procedure);

    ObjectIntMap<K> select(ObjectIntPredicate<? super K> predicate);

    ObjectIntMap<K> reject(ObjectIntPredicate<? super K> predicate);

    /**
     * Returns a string representation of this ObjectIntMap. The string representation consists of a list of the
     * map's key-value pairs in the order they are returned by its iterator. The key and value in each key-value pair are separated
     * by a colon (<tt>":"</tt>) and each pair is enclosed in square brackets (<tt>"[]"</tt>). Adjacent key-value pairs
     * are separated by the characters <tt>", "</tt> (comma and space). Keys and values are converted to strings as by
     * String#valueOf().
     *
     * @return a string representation of this ObjectIntMap
     */
    String toString();

    ImmutableObjectIntMap<K> toImmutable();

    Set<K> keySet();

    MutableIntCollection values();

    /**
     * @since 5.0
     */
    LazyIterable<K> keysView();

    /**
     * @since 5.0
     */
    RichIterable<ObjectIntPair<K>> keyValuesView();
}
