/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.bag.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.bag.primitive.ImmutableCharBag;

/**
 * A factory which creates instances of type {@link ImmutableCharBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableCharBagFactory
{
    /**
     * @since 6.0
     */
    ImmutableCharBag empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableCharBag of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableCharBag with();

    /**
     * Same as {@link #with(char)}.
     */
    ImmutableCharBag of(char one);

    ImmutableCharBag with(char one);

    /**
     * Same as {@link #with(char[])}.
     */
    ImmutableCharBag of(char... items);

    ImmutableCharBag with(char... items);

    /**
     * Same as {@link #withAll(CharIterable)}.
     */
    ImmutableCharBag ofAll(CharIterable items);

    ImmutableCharBag withAll(CharIterable items);
}
