/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.FloatBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableFloatBooleanMap;

/**
 * A factory which creates instances of type {@link ImmutableFloatBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableFloatBooleanMapFactory
{
    /**
     * @since 6.0
     */
    ImmutableFloatBooleanMap empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableFloatBooleanMap of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableFloatBooleanMap with();

    /**
     * Same as {@link #with(float, boolean)}.
     */
    ImmutableFloatBooleanMap of(float key, boolean value);

    ImmutableFloatBooleanMap with(float key, boolean value);

    /**
     * Same as {@link #withAll(FloatBooleanMap)}.
     */
    ImmutableFloatBooleanMap ofAll(FloatBooleanMap map);

    ImmutableFloatBooleanMap withAll(FloatBooleanMap map);
}
