/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableShortList extends ImmutableShortCollection, ShortList
{
    ImmutableShortList select(ShortPredicate predicate);

    ImmutableShortList reject(ShortPredicate predicate);

    <V> ImmutableList<V> collect(ShortToObjectFunction<? extends V> function);

    ImmutableShortList newWith(short element);

    ImmutableShortList newWithout(short element);

    ImmutableShortList newWithAll(ShortIterable elements);

    ImmutableShortList newWithoutAll(ShortIterable elements);

    ImmutableShortList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableShortList distinct();

    ImmutableShortList subList(int fromIndex, int toIndex);
}
