/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.ByteBytePredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableByteByteMap extends ByteByteMap
{
    ImmutableByteByteMap select(ByteBytePredicate predicate);

    ImmutableByteByteMap reject(ByteBytePredicate predicate);

    ImmutableByteCollection select(BytePredicate predicate);

    ImmutableByteCollection reject(BytePredicate predicate);

    <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function);

    ImmutableByteByteMap newWithKeyValue(byte key, byte value);

    ImmutableByteByteMap newWithoutKey(byte key);

    ImmutableByteByteMap newWithoutAllKeys(ByteIterable keys);
}
