/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.LongCharPredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableLongCharMap extends LongCharMap
{
    ImmutableLongCharMap select(LongCharPredicate predicate);

    ImmutableLongCharMap reject(LongCharPredicate predicate);

    ImmutableCharCollection select(CharPredicate predicate);

    ImmutableCharCollection reject(CharPredicate predicate);

    <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function);

    ImmutableLongCharMap newWithKeyValue(long key, char value);

    ImmutableLongCharMap newWithoutKey(long key);

    ImmutableLongCharMap newWithoutAllKeys(LongIterable keys);
}
