/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.ByteDoublePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteDoubleMap extends ByteDoubleMap, MutableDoubleValuesMap
{
    void put(byte key, double value);

    void putAll(ByteDoubleMap map);

    void removeKey(byte key);

    void remove(byte key);

    double removeKeyIfAbsent(byte key, double value);

    double getIfAbsentPut(byte key, double value);

    double getIfAbsentPut(byte key, DoubleFunction0 function);

    double getIfAbsentPutWithKey(byte key, ByteToDoubleFunction function);

    <P> double getIfAbsentPutWith(byte key, DoubleFunction<? super P> function, P parameter);

    double updateValue(byte key, double initialValueIfAbsent, DoubleToDoubleFunction function);

    MutableByteDoubleMap select(ByteDoublePredicate predicate);

    MutableByteDoubleMap reject(ByteDoublePredicate predicate);

    MutableByteDoubleMap withKeyValue(byte key, double value);

    MutableByteDoubleMap withoutKey(byte key);

    MutableByteDoubleMap withoutAllKeys(ByteIterable keys);

    MutableByteDoubleMap asUnmodifiable();

    MutableByteDoubleMap asSynchronized();


    double addToValue(byte key, double toBeAdded);
}
