/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.predicate.primitive.CharBytePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharByteMap extends CharByteMap, MutableByteValuesMap
{
    void put(char key, byte value);

    void putAll(CharByteMap map);

    void removeKey(char key);

    void remove(char key);

    byte removeKeyIfAbsent(char key, byte value);

    byte getIfAbsentPut(char key, byte value);

    byte getIfAbsentPut(char key, ByteFunction0 function);

    byte getIfAbsentPutWithKey(char key, CharToByteFunction function);

    <P> byte getIfAbsentPutWith(char key, ByteFunction<? super P> function, P parameter);

    byte updateValue(char key, byte initialValueIfAbsent, ByteToByteFunction function);

    MutableCharByteMap select(CharBytePredicate predicate);

    MutableCharByteMap reject(CharBytePredicate predicate);

    MutableCharByteMap withKeyValue(char key, byte value);

    MutableCharByteMap withoutKey(char key);

    MutableCharByteMap withoutAllKeys(CharIterable keys);

    MutableCharByteMap asUnmodifiable();

    MutableCharByteMap asSynchronized();


    byte addToValue(char key, byte toBeAdded);
}
