/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.predicate.primitive.FloatBytePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatByteMap extends FloatByteMap, MutableByteValuesMap
{
    void put(float key, byte value);

    void putAll(FloatByteMap map);

    void removeKey(float key);

    void remove(float key);

    byte removeKeyIfAbsent(float key, byte value);

    byte getIfAbsentPut(float key, byte value);

    byte getIfAbsentPut(float key, ByteFunction0 function);

    byte getIfAbsentPutWithKey(float key, FloatToByteFunction function);

    <P> byte getIfAbsentPutWith(float key, ByteFunction<? super P> function, P parameter);

    byte updateValue(float key, byte initialValueIfAbsent, ByteToByteFunction function);

    MutableFloatByteMap select(FloatBytePredicate predicate);

    MutableFloatByteMap reject(FloatBytePredicate predicate);

    MutableFloatByteMap withKeyValue(float key, byte value);

    MutableFloatByteMap withoutKey(float key);

    MutableFloatByteMap withoutAllKeys(FloatIterable keys);

    MutableFloatByteMap asUnmodifiable();

    MutableFloatByteMap asSynchronized();


    byte addToValue(float key, byte toBeAdded);
}
