/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectCharPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.MutableCharIterator;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectCharMap<K> extends ObjectCharMap<K>
{
    MutableCharIterator charIterator();

    void clear();

    void put(K key, char value);

    void putAll(ObjectCharMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    char removeKeyIfAbsent(K key, char value);

    char getIfAbsentPut(K key, char value);

    char getIfAbsentPut(K key, CharFunction0 function);

    char getIfAbsentPutWithKey(K key, CharFunction<? super K> function);

    <P> char getIfAbsentPutWith(K key, CharFunction<? super P> function, P parameter);

    char updateValue(K key, char initialValueIfAbsent, CharToCharFunction function);

    MutableObjectCharMap<K> select(ObjectCharPredicate<? super K> predicate);

    MutableObjectCharMap<K> reject(ObjectCharPredicate<? super K> predicate);

    MutableCharCollection select(CharPredicate predicate);

    MutableCharCollection reject(CharPredicate predicate);

    <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function);

    MutableObjectCharMap<K> withKeyValue(K key, char value);

    MutableObjectCharMap<K> withoutKey(K key);

    MutableObjectCharMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectCharMap<K> asUnmodifiable();

    MutableObjectCharMap<K> asSynchronized();


    char addToValue(K key, char toBeAdded);
}
