/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectLongPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.MutableLongIterator;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectLongMap<K> extends ObjectLongMap<K>
{
    MutableLongIterator longIterator();

    void clear();

    void put(K key, long value);

    void putAll(ObjectLongMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    long removeKeyIfAbsent(K key, long value);

    long getIfAbsentPut(K key, long value);

    long getIfAbsentPut(K key, LongFunction0 function);

    long getIfAbsentPutWithKey(K key, LongFunction<? super K> function);

    <P> long getIfAbsentPutWith(K key, LongFunction<? super P> function, P parameter);

    long updateValue(K key, long initialValueIfAbsent, LongToLongFunction function);

    MutableObjectLongMap<K> select(ObjectLongPredicate<? super K> predicate);

    MutableObjectLongMap<K> reject(ObjectLongPredicate<? super K> predicate);

    MutableLongCollection select(LongPredicate predicate);

    MutableLongCollection reject(LongPredicate predicate);

    <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function);

    MutableObjectLongMap<K> withKeyValue(K key, long value);

    MutableObjectLongMap<K> withoutKey(K key);

    MutableObjectLongMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectLongMap<K> asUnmodifiable();

    MutableObjectLongMap<K> asSynchronized();


    long addToValue(K key, long toBeAdded);
}
