/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectShortPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.MutableShortIterator;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectShortMap<K> extends ObjectShortMap<K>
{
    MutableShortIterator shortIterator();

    void clear();

    void put(K key, short value);

    void putAll(ObjectShortMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    short removeKeyIfAbsent(K key, short value);

    short getIfAbsentPut(K key, short value);

    short getIfAbsentPut(K key, ShortFunction0 function);

    short getIfAbsentPutWithKey(K key, ShortFunction<? super K> function);

    <P> short getIfAbsentPutWith(K key, ShortFunction<? super P> function, P parameter);

    short updateValue(K key, short initialValueIfAbsent, ShortToShortFunction function);

    MutableObjectShortMap<K> select(ObjectShortPredicate<? super K> predicate);

    MutableObjectShortMap<K> reject(ObjectShortPredicate<? super K> predicate);

    MutableShortCollection select(ShortPredicate predicate);

    MutableShortCollection reject(ShortPredicate predicate);

    <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function);

    MutableObjectShortMap<K> withKeyValue(K key, short value);

    MutableObjectShortMap<K> withoutKey(K key);

    MutableObjectShortMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectShortMap<K> asUnmodifiable();

    MutableObjectShortMap<K> asSynchronized();


    short addToValue(K key, short toBeAdded);
}
