/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains interfaces for {@link com.gs.collections.api.partition.bag.PartitionBag}.
 * <p>
 *     A PartitionBag is the result of splitting a {@link com.gs.collections.api.bag.Bag} into two bags based on a Predicate.
 * <p>
 *      This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link com.gs.collections.api.partition.bag.PartitionBag} - a read-only PartitionBag API.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.partition.bag.PartitionMutableBag} - a modifiable PartitionBag.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.partition.bag.PartitionImmutableBag} - the non-modifiable equivalent interface to {@link com.gs.collections.api.partition.bag.PartitionMutableBag}.
 *     </li>
 * </ul>
 */
package com.gs.collections.api.partition.bag;
