/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.set.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableShortSet extends MutableShortCollection, ShortSet
{
    MutableShortSet select(ShortPredicate predicate);

    MutableShortSet reject(ShortPredicate predicate);

    <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function);

    MutableShortSet with(short element);

    MutableShortSet without(short element);

    MutableShortSet withAll(ShortIterable elements);

    MutableShortSet withoutAll(ShortIterable elements);

    MutableShortSet asUnmodifiable();

    MutableShortSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    ShortSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableShortSet toImmutable();
}
