/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl;

import java.util.ListIterator;
import java.util.NoSuchElementException;

import net.jcip.annotations.Immutable;

/**
 * A Singleton iterator which is empty and can be used by all empty collections.
 */
@Immutable
public final class EmptyIterator<T>
        implements ListIterator<T>
{
    private static final EmptyIterator<?> INSTANCE = new EmptyIterator<Object>();

    private EmptyIterator()
    {
    }

    public static <T> EmptyIterator<T> getInstance()
    {
        return (EmptyIterator<T>) INSTANCE;
    }

    public boolean hasNext()
    {
        return false;
    }

    public T next()
    {
        throw new NoSuchElementException();
    }

    public void remove()
    {
        throw new UnsupportedOperationException();
    }

    public boolean hasPrevious()
    {
        return false;
    }

    public T previous()
    {
        throw new NoSuchElementException();
    }

    public int nextIndex()
    {
        return 0;
    }

    public int previousIndex()
    {
        return -1;
    }

    public void set(T t)
    {
        throw new UnsupportedOperationException();
    }

    public void add(T t)
    {
        throw new UnsupportedOperationException();
    }
}
