/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.bag.primitive.ImmutableLongBagFactory;
import com.gs.collections.api.bag.primitive.ImmutableLongBag;

/**
 * ImmutableLongBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongBagFactoryImpl implements ImmutableLongBagFactory
{
    public ImmutableLongBag of()
    {
        return this.with();
    }

    public ImmutableLongBag with()
    {
        return ImmutableLongEmptyBag.INSTANCE;
    }

    public ImmutableLongBag of(long one)
    {
        return this.with(one);
    }

    public ImmutableLongBag with(long one)
    {
        return new ImmutableLongSingletonBag(one);
    }

    public ImmutableLongBag of(long... items)
    {
        return this.with(items);
    }

    public ImmutableLongBag with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableLongHashBag.newBagWith(items);
    }

    public ImmutableLongBag ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableLongBag withAll(LongIterable items)
    {
        if (items instanceof ImmutableLongBag)
        {
            return (ImmutableLongBag) items;
        }
        return this.with(items.toArray());
    }
}
