/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.collection.mutable.primitive;

import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import net.jcip.annotations.ThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveCollection.stg.
 *
 * @since 4.0.
 */
@ThreadSafe
public class UnmodifiableBooleanCollection
        extends AbstractUnmodifiableBooleanCollection
{
    private static final long serialVersionUID = 1L;

    protected UnmodifiableBooleanCollection(MutableBooleanCollection collection)
    {
        super(collection);
    }

    /**
     * This method will take a MutableBooleanCollection and wrap it directly in a UnmodifiableBooleanCollection.
     */
    public static UnmodifiableBooleanCollection of(MutableBooleanCollection collection)
    {
        if (collection == null)
        {
            throw new IllegalArgumentException("cannot create a UnmodifiableBooleanCollection for null");
        }
        return new UnmodifiableBooleanCollection(collection);
    }
}
