/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.factory.primitive;

import com.gs.collections.api.factory.bag.primitive.ImmutableLongBagFactory;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableLongBagFactoryImpl;

/**
 * LongBags is a static utility for creating {@link ImmutableLongBagFactory}.
 * This file was automatically generated from template file primitiveBags.stg.
 *
 * @since 4.0.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class LongBags
{
    public static final ImmutableLongBagFactory immutable = new ImmutableLongBagFactoryImpl();

    private LongBags()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
