/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.block.factory.primitive.BytePredicates;

/**
 * This file was automatically generated from template file primitiveLazyIterableAdapter.stg.
 *
 * @since 3.0
 */
public class LazyByteIterableAdapter
        implements LazyByteIterable
{
    private final ByteIterable delegate;

    public LazyByteIterableAdapter(ByteIterable delegate)
    {
        this.delegate = delegate;
    }

    public ByteIterator byteIterator()
    {
        return this.delegate.byteIterator();
    }

    public void forEach(ByteProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public int count(BytePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public LazyByteIterable select(BytePredicate predicate)
    {
        return new SelectByteIterable(this.delegate, predicate);
    }

    public LazyByteIterable reject(BytePredicate predicate)
    {
        return new SelectByteIterable(this.delegate, BytePredicates.not(predicate));
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> LazyIterable<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return new CollectByteToObjectIterable<V>(this.delegate, function);
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public byte max()
    {
        return this.delegate.max();
    }

    public byte min()
    {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public byte[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public byte[] toArray()
    {
        return this.delegate.toArray();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public boolean contains(byte value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.delegate.toList();
    }

    public MutableByteSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this;
    }
}
