/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.block.factory.primitive.CharPredicates;

/**
 * This file was automatically generated from template file primitiveLazyIterableAdapter.stg.
 *
 * @since 3.0
 */
public class LazyCharIterableAdapter
        implements LazyCharIterable
{
    private final CharIterable delegate;

    public LazyCharIterableAdapter(CharIterable delegate)
    {
        this.delegate = delegate;
    }

    public CharIterator charIterator()
    {
        return this.delegate.charIterator();
    }

    public void forEach(CharProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public int count(CharPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public LazyCharIterable select(CharPredicate predicate)
    {
        return new SelectCharIterable(this.delegate, predicate);
    }

    public LazyCharIterable reject(CharPredicate predicate)
    {
        return new SelectCharIterable(this.delegate, CharPredicates.not(predicate));
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> LazyIterable<V> collect(CharToObjectFunction<? extends V> function)
    {
        return new CollectCharToObjectIterable<V>(this.delegate, function);
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public char max()
    {
        return this.delegate.max();
    }

    public char min()
    {
        return this.delegate.min();
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public char[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableCharList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public char[] toArray()
    {
        return this.delegate.toArray();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public boolean contains(char value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(char... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(CharIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableCharList toList()
    {
        return this.delegate.toList();
    }

    public MutableCharSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableCharBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyCharIterable asLazy()
    {
        return this;
    }
}
