/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import java.util.Collection;
import java.util.Collections;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.list.primitive.ImmutableShortList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedShortCollection;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/**
 * A synchronized view of a {@link MutableShortList}. It is imperative that the user manually synchronize on the collection when iterating over it using the
 * {@link ShortIterator}, as per {@link Collections#synchronizedCollection(Collection)}.
 * <p>
 * This file was automatically generated from template file synchronizedPrimitiveList.stg.
 * </p>
 *
 * @see MutableShortList#asSynchronized()
 * @see MutableList#asSynchronized()
 * @since 3.1.
 */
@ThreadSafe
public final class SynchronizedShortList
        extends AbstractSynchronizedShortCollection
        implements MutableShortList
{
    private static final long serialVersionUID = 1L;

    SynchronizedShortList(MutableShortList list)
    {
        super(list);
    }

    SynchronizedShortList(MutableShortList list, Object newLock)
    {
        super(list, newLock);
    }

    @GuardedBy("getLock()")
    private MutableShortList getMutableShortList()
    {
        return (MutableShortList) this.getShortCollection();
    }

    public short get(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().get(index);
        }
    }

    public short getFirst()
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().getFirst();
        }
    }

    public short getLast()
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().getLast();
        }
    }

    public int indexOf(short value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().indexOf(value);
        }
    }

    public int lastIndexOf(short value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().lastIndexOf(value);
        }
    }

    public void addAtIndex(int index, short element)
    {
        synchronized (this.getLock())
        {
            this.getMutableShortList().addAtIndex(index, element);
        }
    }

    public boolean addAllAtIndex(int index, short... source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().addAllAtIndex(index, source);
        }
    }

    public boolean addAllAtIndex(int index, ShortIterable source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().addAllAtIndex(index, source);
        }
    }

    public short removeAtIndex(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().removeAtIndex(index);
        }
    }

    public short set(int index, short element)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().set(index, element);
        }
    }

    @Override
    public SynchronizedShortList with(short element)
    {
        synchronized (this.getLock())
        {
            this.getMutableShortList().add(element);
        }
        return this;
    }

    @Override
    public SynchronizedShortList without(short element)
    {
        synchronized (this.getLock())
        {
            this.getMutableShortList().remove(element);
        }
        return this;
    }

    @Override
    public SynchronizedShortList withAll(ShortIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableShortList().addAll(elements.toArray());
        }
        return this;
    }

    @Override
    public SynchronizedShortList withoutAll(ShortIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableShortList().removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableShortList select(ShortPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().select(predicate);
        }
    }

    @Override
    public MutableShortList reject(ShortPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().reject(predicate);
        }
    }

    @Override
    public <V> MutableList<V> collect(ShortToObjectFunction<? extends V> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().collect(function);
        }
    }

    public MutableShortList sortThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableShortList().sortThis();
        }
        return this;
    }

    public long dotProduct(ShortList list)
    {
        return this.getMutableShortList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().equals(otherList);
        }
    }

    @Override
    public int hashCode()
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().hashCode();
        }
    }

    @Override
    public LazyShortIterable asLazy()
    {
        synchronized (this.getLock())
        {
            return new LazyShortIterableAdapter(this);
        }
    }

    @Override
    public MutableShortList asUnmodifiable()
    {
        return new UnmodifiableShortList(this);
    }

    @Override
    public MutableShortList asSynchronized()
    {
        return this;
    }

    @Override
    public ImmutableShortList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return ShortLists.immutable.with();
        }
        if (size == 1)
        {
            return ShortLists.immutable.with(this.getFirst());
        }
        return ShortLists.immutable.with(this.toArray());
    }

    public MutableShortList reverseThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableShortList().reverseThis();
        }
        return this;
    }

    public MutableShortList toReversed()
    {
        synchronized (this.getLock())
        {
            return this.getMutableShortList().toReversed();
        }
    }
}
