/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.LongList;
import com.gs.collections.api.list.primitive.ImmutableLongList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableLongCollection;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveList.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableLongList
        extends AbstractUnmodifiableLongCollection
        implements MutableLongList
{
    private static final long serialVersionUID = 1L;

    UnmodifiableLongList(MutableLongList list)
    {
        super(list);
    }

    private MutableLongList getMutableLongList()
    {
        return (MutableLongList) this.getLongCollection();
    }

    public long get(int index)
    {
        return this.getMutableLongList().get(index);
    }

    public long getFirst()
    {
        return this.getMutableLongList().getFirst();
    }

    public long getLast()
    {
        return this.getMutableLongList().getLast();
    }

    public int indexOf(long value)
    {
        return this.getMutableLongList().indexOf(value);
    }

    public int lastIndexOf(long value)
    {
        return this.getMutableLongList().lastIndexOf(value);
    }

    public void addAtIndex(int index, long element)
    {
        throw new UnsupportedOperationException("Cannot call addAtIndex on an unmodifiable collection");
    }

    public boolean addAllAtIndex(int index, long... source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex on an unmodifiable collection");
    }

    public boolean addAllAtIndex(int index, LongIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex on an unmodifiable collection");
    }

    public long removeAtIndex(int index)
    {
        throw new UnsupportedOperationException("Cannot call removeAtIndex on an unmodifiable collection");
    }

    public long set(int index, long element)
    {
        throw new UnsupportedOperationException("Cannot call set on an unmodifiable collection");
    }

    @Override
    public UnmodifiableLongList with(long element)
    {
        throw new UnsupportedOperationException("Cannot call with on an unmodifiable collection");
    }

    @Override
    public UnmodifiableLongList without(long element)
    {
        throw new UnsupportedOperationException("Cannot call without on an unmodifiable collection");
    }

    @Override
    public UnmodifiableLongList withAll(LongIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll on an unmodifiable collection");
    }

    @Override
    public UnmodifiableLongList withoutAll(LongIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll on an unmodifiable collection");
    }

    @Override
    public MutableLongList select(LongPredicate predicate)
    {
        return this.getMutableLongList().select(predicate);
    }

    @Override
    public MutableLongList reject(LongPredicate predicate)
    {
        return this.getMutableLongList().reject(predicate);
    }

    @Override
    public <V> MutableList<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.getMutableLongList().collect(function);
    }

    public MutableLongList sortThis()
    {
        throw new UnsupportedOperationException("Cannot call sortThis on an unmodifiable collection");
    }

    public long dotProduct(LongList list)
    {
        return this.getMutableLongList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        return this.getMutableLongList().equals(otherList);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableLongList().hashCode();
    }

    @Override
    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public MutableLongList asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableLongList asSynchronized()
    {
        return new SynchronizedLongList(this);
    }

    @Override
    public ImmutableLongList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return LongLists.immutable.with();
        }
        if (size == 1)
        {
            return LongLists.immutable.with(this.getFirst());
        }
        return LongLists.immutable.with(this.toArray());
    }

    public MutableLongList reverseThis()
    {
        throw new UnsupportedOperationException("Cannot call reverseThis on an unmodifiable collection");
    }

    public MutableLongList toReversed()
    {
        return this.getMutableLongList().toReversed();
    }
}
