/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.list.primitive.ImmutableShortList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableShortCollection;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveList.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableShortList
        extends AbstractUnmodifiableShortCollection
        implements MutableShortList
{
    private static final long serialVersionUID = 1L;

    UnmodifiableShortList(MutableShortList list)
    {
        super(list);
    }

    private MutableShortList getMutableShortList()
    {
        return (MutableShortList) this.getShortCollection();
    }

    public short get(int index)
    {
        return this.getMutableShortList().get(index);
    }

    public short getFirst()
    {
        return this.getMutableShortList().getFirst();
    }

    public short getLast()
    {
        return this.getMutableShortList().getLast();
    }

    public int indexOf(short value)
    {
        return this.getMutableShortList().indexOf(value);
    }

    public int lastIndexOf(short value)
    {
        return this.getMutableShortList().lastIndexOf(value);
    }

    public void addAtIndex(int index, short element)
    {
        throw new UnsupportedOperationException("Cannot call addAtIndex on an unmodifiable collection");
    }

    public boolean addAllAtIndex(int index, short... source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex on an unmodifiable collection");
    }

    public boolean addAllAtIndex(int index, ShortIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex on an unmodifiable collection");
    }

    public short removeAtIndex(int index)
    {
        throw new UnsupportedOperationException("Cannot call removeAtIndex on an unmodifiable collection");
    }

    public short set(int index, short element)
    {
        throw new UnsupportedOperationException("Cannot call set on an unmodifiable collection");
    }

    @Override
    public UnmodifiableShortList with(short element)
    {
        throw new UnsupportedOperationException("Cannot call with on an unmodifiable collection");
    }

    @Override
    public UnmodifiableShortList without(short element)
    {
        throw new UnsupportedOperationException("Cannot call without on an unmodifiable collection");
    }

    @Override
    public UnmodifiableShortList withAll(ShortIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll on an unmodifiable collection");
    }

    @Override
    public UnmodifiableShortList withoutAll(ShortIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll on an unmodifiable collection");
    }

    @Override
    public MutableShortList select(ShortPredicate predicate)
    {
        return this.getMutableShortList().select(predicate);
    }

    @Override
    public MutableShortList reject(ShortPredicate predicate)
    {
        return this.getMutableShortList().reject(predicate);
    }

    @Override
    public <V> MutableList<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.getMutableShortList().collect(function);
    }

    public MutableShortList sortThis()
    {
        throw new UnsupportedOperationException("Cannot call sortThis on an unmodifiable collection");
    }

    public long dotProduct(ShortList list)
    {
        return this.getMutableShortList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        return this.getMutableShortList().equals(otherList);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableShortList().hashCode();
    }

    @Override
    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public MutableShortList asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableShortList asSynchronized()
    {
        return new SynchronizedShortList(this);
    }

    @Override
    public ImmutableShortList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return ShortLists.immutable.with();
        }
        if (size == 1)
        {
            return ShortLists.immutable.with(this.getFirst());
        }
        return ShortLists.immutable.with(this.toArray());
    }

    public MutableShortList reverseThis()
    {
        throw new UnsupportedOperationException("Cannot call reverseThis on an unmodifiable collection");
    }

    public MutableShortList toReversed()
    {
        return this.getMutableShortList().toReversed();
    }
}
