/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import com.gs.collections.api.map.primitive.ImmutableLongObjectMap;
import com.gs.collections.api.map.primitive.LongObjectMap;
import com.gs.collections.api.map.primitive.MutableLongObjectMap;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedLongObjectProcedure;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveObjectMap.stg.
 *
 * @since 4.0.
 */
public abstract class AbstractImmutableLongObjectMap<V> implements ImmutableLongObjectMap<V>
{
    protected static class ImmutableLongObjectMapSerializationProxy<V> implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private LongObjectMap<V> map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableLongObjectMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableLongObjectMapSerializationProxy(LongObjectMap<V> map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedLongObjectProcedure<V>()
                {
                    @Override
                    public void safeValue(long key, V value) throws IOException
                    {
                        out.writeLong(key);
                        out.writeObject(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableLongObjectMap<V> deserializedMap = new LongObjectHashMap<V>();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readLong(), (V) in.readObject());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
