/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.ByteBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ByteBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableByteBooleanMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.map.mutable.primitive.ByteBooleanHashMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;

/**
 * ImmutableByteBooleanEmptyMap is an optimization for {@link ImmutableByteBooleanMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableByteBooleanEmptyMap implements ImmutableByteBooleanMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final boolean EMPTY_VALUE = false;
    static final ImmutableByteBooleanMap INSTANCE = new ImmutableByteBooleanEmptyMap();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public boolean get(byte key)
    {
        return EMPTY_VALUE;
    }

    public boolean getIfAbsent(byte key, boolean ifAbsent)
    {
        return ifAbsent;
    }

    public boolean getOrThrow(byte key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key)
    {
        return false;
    }

    public boolean containsValue(boolean value)
    {
        return false;
    }

    public void forEachValue(BooleanProcedure procedure)
    {
    }

    public void forEachKey(ByteProcedure procedure)
    {
    }

    public void forEachKeyValue(ByteBooleanProcedure procedure)
    {
    }

    public LazyByteIterable keysView()
    {
        return new ByteBooleanHashMap(0).keysView();
    }

    public ImmutableByteBooleanMap select(ByteBooleanPredicate predicate)
    {
        return this;
    }

    public ImmutableByteBooleanMap reject(ByteBooleanPredicate predicate)
    {
        return this;
    }

    public ImmutableByteBooleanMap toImmutable()
    {
        return this;
    }

    public BooleanIterator booleanIterator()
    {
        return new InternalBooleanIterator();
    }

    private static class InternalBooleanIterator implements BooleanIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public boolean next()
        {
            throw new NoSuchElementException();
        }
    }

    public void forEach(BooleanProcedure procedure)
    {
    }

    public int count(BooleanPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return true;
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate)
    {
        return BooleanLists.immutable.with();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate)
    {
        return BooleanLists.immutable.with();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public boolean[] toArray()
    {
        return new boolean[0];
    }

    public boolean contains(boolean value)
    {
        return false;
    }

    public boolean containsAll(boolean... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(BooleanIterable source)
    {
        return source.isEmpty();
    }

    public MutableBooleanList toList()
    {
        return new BooleanArrayList();
    }

    public MutableBooleanSet toSet()
    {
        return new BooleanHashSet();
    }

    public MutableBooleanBag toBag()
    {
        return new BooleanHashBag();
    }

    public LazyBooleanIterable asLazy()
    {
        return new LazyBooleanIterableAdapter(this);
    }

    public ImmutableByteBooleanMap newWithKeyValue(byte key, boolean value)
    {
        return new ImmutableByteBooleanSingletonMap(key, value);
    }

    public ImmutableByteBooleanMap newWithoutKey(byte key)
    {
        return this;
    }

    public ImmutableByteBooleanMap newWithoutAllKeys(ByteIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableByteSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableBooleanCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ByteBooleanMap))
        {
            return false;
        }
        ByteBooleanMap map = (ByteBooleanMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
