/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableByteCharMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteCharMap;
import com.gs.collections.api.map.primitive.ByteCharMap;

/**
 * ImmutableByteCharMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteCharMapFactoryImpl implements ImmutableByteCharMapFactory
{
    public ImmutableByteCharMap of()
    {
        return this.with();
    }

    public ImmutableByteCharMap with()
    {
        return ImmutableByteCharEmptyMap.INSTANCE;
    }

    public ImmutableByteCharMap of(byte key, char value)
    {
        return this.with(key, value);
    }

    public ImmutableByteCharMap with(byte key, char value)
    {
        return new ImmutableByteCharSingletonMap(key, value);
    }

    public ImmutableByteCharMap ofAll(ByteCharMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteCharMap withAll(ByteCharMap map)
    {
        if (map instanceof ImmutableByteCharMap)
        {
            return (ImmutableByteCharMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteCharSingletonMap(key, map.get(key));
        }
        return new ImmutableByteCharHashMap(map);
    }
}
