/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.ByteLongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteLongProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ByteLongMap;
import com.gs.collections.api.map.primitive.ImmutableByteLongMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ByteLongMaps;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.ByteLongHashMap;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;

/**
 * ImmutableByteLongSingletonMap is an optimization for {@link ImmutableByteLongMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableByteLongSingletonMap implements ImmutableByteLongMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    private final byte key1;
    private final long value1;

    ImmutableByteLongSingletonMap(byte key1, long value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public long get(byte key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public long getIfAbsent(byte key, long ifAbsent)
    {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public long getOrThrow(byte key)
    {
        if (this.key1 == key)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key)
    {
        return this.key1 == key;
    }

    public boolean containsValue(long value)
    {
        return this.value1 == value;
    }

    public void forEachValue(LongProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(ByteProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ByteLongProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyByteIterable keysView()
    {
        return ByteLongHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableByteLongMap select(ByteLongPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? ByteLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new ByteLongHashMap().toImmutable();
    }

    public ImmutableByteLongMap reject(ByteLongPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new ByteLongHashMap().toImmutable()
                : ByteLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableByteLongMap toImmutable()
    {
        return this;
    }

    public LongIterator longIterator()
    {
        return ByteLongHashMap.newWithKeysValues(this.key1, this.value1).longIterator();
    }

    public void forEach(LongProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum()
    {
        return this.value1;
    }

    public long min()
    {
        return this.value1;
    }

    public long max()
    {
        return this.value1;
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.value1;
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public long[] toSortedArray()
    {
        return new long[]{this.value1};
    }

    public MutableLongList toSortedList()
    {
        return LongArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableLongCollection select(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? LongArrayList.newListWith(this.value1).toImmutable() : new LongArrayList().toImmutable();
    }

    public ImmutableLongCollection reject(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? new LongArrayList().toImmutable() : LongArrayList.newListWith(this.value1).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long[] toArray()
    {
        return new long[]{this.value1};
    }

    public boolean contains(long value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(long... source)
    {
        for (long value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(LongIterable source)
    {
        for (LongIterator iterator = source.longIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableLongList toList()
    {
        return LongArrayList.newListWith(this.value1);
    }

    public MutableLongSet toSet()
    {
        return LongHashSet.newSetWith(this.value1);
    }

    public MutableLongBag toBag()
    {
        return LongHashBag.newBagWith(this.value1);
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public ImmutableByteLongMap newWithKeyValue(byte key, long value)
    {
        return ByteLongMaps.immutable.withAll(ByteLongHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableByteLongMap newWithoutKey(byte key)
    {
        return this.key1 == key ? ByteLongMaps.immutable.with() : this;
    }

    public ImmutableByteLongMap newWithoutAllKeys(ByteIterable keys)
    {
        return keys.contains(this.key1) ? ByteLongMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableByteSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableLongCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ByteLongMap))
        {
            return false;
        }
        ByteLongMap map = (ByteLongMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return (int) this.key1 ^ (int) (this.value1 ^ this.value1 >>> 32);
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
