/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.ByteObjectPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ByteObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.ByteObjectMap;
import com.gs.collections.api.map.primitive.ImmutableByteObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.PartitionIterable;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.SortedMaps;
import com.gs.collections.impl.factory.SortedSets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.LazyIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;

/**
 * ImmutableByteObjectEmptyMap is an optimization for {@link ImmutableByteObjectMap} of size 0.
 * This file was automatically generated from template file immutablePrimitiveObjectEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableByteObjectEmptyMap<V> implements ImmutableByteObjectMap<V>, Serializable
{
    private static final long serialVersionUID = 1L;
    static final ImmutableByteObjectMap<?> INSTANCE = new ImmutableByteObjectEmptyMap<Object>();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public V get(byte key)
    {
        return null;
    }

    public V getIfAbsent(byte key, Function0<? extends V> ifAbsent)
    {
        return ifAbsent.value();
    }

    public boolean containsKey(byte key)
    {
        return false;
    }

    public boolean containsValue(Object value)
    {
        return false;
    }

    public void forEachValue(Procedure<? super V> procedure)
    {
    }

    public void forEachKey(ByteProcedure procedure)
    {
    }

    public void forEachKeyValue(ByteObjectProcedure<? super V> procedure)
    {
    }

    public ImmutableByteObjectMap<V> select(ByteObjectPredicate<? super V> predicate)
    {
        return this;
    }

    public ImmutableByteObjectMap<V> reject(ByteObjectPredicate<? super V> predicate)
    {
        return this;
    }

    public ImmutableByteObjectMap<V> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public V getFirst()
    {
        return null;
    }

    public V getLast()
    {
        return null;
    }

    public boolean contains(Object object)
    {
        return false;
    }

    public boolean containsAllIterable(Iterable<?> source)
    {
        return !source.iterator().hasNext();
    }

    public boolean containsAll(Collection<?> source)
    {
        return source.isEmpty();
    }

    public boolean containsAllArguments(Object... elements)
    {
        return elements.length == 0;
    }

    public ImmutableCollection<V> select(Predicate<? super V> predicate)
    {
        return Lists.immutable.with();
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target)
    {
        return target;
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection)
    {
        return targetCollection;
    }

    public ImmutableCollection<V> reject(Predicate<? super V> predicate)
    {
        return Lists.immutable.with();
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target)
    {
        return target;
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection)
    {
        return targetCollection;
    }

    public PartitionIterable<V> partition(Predicate<? super V> predicate)
    {
        return new PartitionFastList<V>();
    }

    public <S> RichIterable<S> selectInstancesOf(Class<S> clazz)
    {
        return Lists.mutable.with();
    }

    public <V1> ImmutableCollection<V1> collect(Function<? super V, ? extends V1> function)
    {
        return Lists.immutable.with();
    }

    public ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction)
    {
        return BooleanLists.immutable.with();
    }

    public ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction)
    {
        return ByteLists.immutable.with();
    }

    public ImmutableCharCollection collectChar(CharFunction<? super V> charFunction)
    {
        return CharLists.immutable.with();
    }

    public ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction)
    {
        return DoubleLists.immutable.with();
    }

    public ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction)
    {
        return FloatLists.immutable.with();
    }

    public ImmutableIntCollection collectInt(IntFunction<? super V> intFunction)
    {
        return IntLists.immutable.with();
    }

    public ImmutableLongCollection collectLong(LongFunction<? super V> longFunction)
    {
        return LongLists.immutable.with();
    }

    public ImmutableShortCollection collectShort(ShortFunction<? super V> shortFunction)
    {
        return ShortLists.immutable.with();
    }

    public <V1> RichIterable<V1> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function)
    {
        return Lists.mutable.with();
    }

    public <V1> RichIterable<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function)
    {
        return Lists.mutable.with();
    }

    public V detect(Predicate<? super V> predicate)
    {
        return null;
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function)
    {
        return function.value();
    }

    public int count(Predicate<? super V> predicate)
    {
        return 0;
    }

    public boolean anySatisfy(Predicate<? super V> predicate)
    {
        return false;
    }

    public boolean allSatisfy(Predicate<? super V> predicate)
    {
        return true;
    }

    public boolean noneSatisfy(Predicate<? super V> predicate)
    {
        return true;
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function)
    {
        return injectedValue;
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function)
    {
        return injectedValue;
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function)
    {
        return injectedValue;
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function)
    {
        return injectedValue;
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function)
    {
        return injectedValue;
    }

    public MutableList<V> toList()
    {
        return Lists.mutable.with();
    }

    public MutableList<V> toSortedList()
    {
        return Lists.mutable.with();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator)
    {
        return Lists.mutable.with();
    }

    public MutableSet<V> toSet()
    {
        return Sets.mutable.with();
    }

    public MutableSortedSet<V> toSortedSet()
    {
        return SortedSets.mutable.with();
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator)
    {
        return SortedSets.mutable.with();
    }

    public MutableBag<V> toBag()
    {
        return Bags.mutable.with();
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return Maps.mutable.with();
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return SortedMaps.mutable.with();
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return SortedMaps.mutable.with();
    }

    public LazyIterable<V> asLazy()
    {
        return new LazyIterableAdapter<V>(FastList.<V>newListWith());
    }

    public Object[] toArray()
    {
        return new Object[0];
    }

    public <T> T[] toArray(T[] a)
    {
        return (T[]) new Object[0];
    }

    public V min(Comparator<? super V> comparator)
    {
        throw new NoSuchElementException();
    }

    public V max(Comparator<? super V> comparator)
    {
        throw new NoSuchElementException();
    }

    public V min()
    {
        throw new NoSuchElementException();
    }

    public V max()
    {
        throw new NoSuchElementException();
    }

    public long sumOfInt(IntFunction<? super V> function)
    {
        return 0L;
    }

    public double sumOfFloat(FloatFunction<? super V> function)
    {
        return 0.0;
    }

    public long sumOfLong(LongFunction<? super V> function)
    {
        return 0L;
    }

    public double sumOfDouble(DoubleFunction<? super V> function)
    {
        return 0.0;
    }

    public MutableByteSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public Collection<V> values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ByteObjectMap))
        {
            return false;
        }
        ByteObjectMap<V> map = (ByteObjectMap<V>) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public <V1> Multimap<V1, V> groupBy(Function<? super V, ? extends V1> function)
    {
        return FastListMultimap.newMultimap();
    }

    public <V1> Multimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function)
    {
        return FastListMultimap.newMultimap();
    }

    public <S> RichIterable<Pair<V, S>> zip(Iterable<S> that)
    {
        return Lists.immutable.of();
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target)
    {
        return target;
    }

    public RichIterable<Pair<V, Integer>> zipWithIndex()
    {
        return Lists.immutable.of();
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target)
    {
        return target;
    }

    public RichIterable<RichIterable<V>> chunk(int size)
    {
        return Lists.immutable.of();
    }

    public <K, V1> MapIterable<K, V1> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Procedure2<? super V1, ? super V> mutatingAggregator)
    {
        return Maps.immutable.with();
    }

    public <K, V1> MapIterable<K, V1> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Function2<? super V1, ? super V, ? extends V1> nonMutatingAggregator)
    {
        return Maps.immutable.with();
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupByEach(Function<? super V, ? extends Iterable<V1>> function, R target)
    {
        return target;
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupBy(Function<? super V, ? extends V1> function, R target)
    {
        return target;
    }

    public <V1 extends Comparable<? super V1>> V maxBy(Function<? super V, ? extends V1> function)
    {
        throw new NoSuchElementException();
    }

    public <V1 extends Comparable<? super V1>> V minBy(Function<? super V, ? extends V1> function)
    {
        throw new NoSuchElementException();
    }

    public <V1 extends Comparable<? super V1>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends V1> function)
    {
        return SortedSets.mutable.of();
    }

    public <V1 extends Comparable<? super V1>> MutableList<V> toSortedListBy(Function<? super V, ? extends V1> function)
    {
        return Lists.mutable.of();
    }

    public <V1, R extends Collection<V1>> R flatCollect(Function<? super V, ? extends Iterable<V1>> function, R target)
    {
        return target;
    }

    public <V1, R extends Collection<V1>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function, R target)
    {
        return target;
    }

    public <P, V1, R extends Collection<V1>> R collectWith(Function2<? super V, ? super P, ? extends V1> function, P parameter, R targetCollection)
    {
        return targetCollection;
    }

    public <V1, R extends Collection<V1>> R collect(Function<? super V, ? extends V1> function, R target)
    {
        return target;
    }

    public ImmutableByteObjectMap<V> newWithKeyValue(byte key, V value)
    {
        ByteObjectHashMap<V> map = new ByteObjectHashMap<V>();
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableByteObjectMap<V> newWithoutKey(byte key)
    {
        return this;
    }

    public ImmutableByteObjectMap<V> newWithoutAllKeys(ByteIterable keys)
    {
        return this;
    }

    public void forEach(Procedure<? super V> procedure)
    {
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure)
    {
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter)
    {
    }

    public Iterator<V> iterator()
    {
        return new InternalIterator();
    }

    private class InternalIterator implements Iterator<V>
    {
        public boolean hasNext()
        {
            return false;
        }

        public V next()
        {
            throw new NoSuchElementException();
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }
    }
}
