/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.factory.map.primitive.ImmutableByteObjectMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteObjectMap;
import com.gs.collections.api.map.primitive.ByteObjectMap;

/**
 * ImmutableByteObjectMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteObjectMapFactoryImpl implements ImmutableByteObjectMapFactory
{
    public <V> ImmutableByteObjectMap<V> of()
    {
        return this.with();
    }

    public <V> ImmutableByteObjectMap<V> with()
    {
        return (ImmutableByteObjectMap<V>) ImmutableByteObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableByteObjectMap<V> of(byte key, V value)
    {
        return this.with(key, value);
    }

    public <V> ImmutableByteObjectMap<V> with(byte key, V value)
    {
        return new ImmutableByteObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableByteObjectMap<V> ofAll(ByteObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> ImmutableByteObjectMap<V> withAll(ByteObjectMap<? extends V> map)
    {
        if (map instanceof ImmutableByteObjectMap)
        {
            return (ImmutableByteObjectMap<V>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final byte[] array = new byte[1];
            map.forEachKey(new ByteProcedure()
            {
                public void value(byte each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableByteObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableByteObjectHashMap<V>(map);
    }
}
