/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.CharDoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.CharDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.CharDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableCharDoubleMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharDoubleMaps;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.CharDoubleHashMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;

/**
 * ImmutableCharDoubleSingletonMap is an optimization for {@link ImmutableCharDoubleMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableCharDoubleSingletonMap implements ImmutableCharDoubleMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;
    private final char key1;
    private final double value1;

    ImmutableCharDoubleSingletonMap(char key1, double value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public double get(char key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public double getIfAbsent(char key, double ifAbsent)
    {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public double getOrThrow(char key)
    {
        if (this.key1 == key)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key)
    {
        return this.key1 == key;
    }

    public boolean containsValue(double value)
    {
        return Double.compare(this.value1, value) == 0;
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(CharProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(CharDoubleProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyCharIterable keysView()
    {
        return CharDoubleHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableCharDoubleMap select(CharDoublePredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? CharDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new CharDoubleHashMap().toImmutable();
    }

    public ImmutableCharDoubleMap reject(CharDoublePredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new CharDoubleHashMap().toImmutable()
                : CharDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableCharDoubleMap toImmutable()
    {
        return this;
    }

    public DoubleIterator doubleIterator()
    {
        return CharDoubleHashMap.newWithKeysValues(this.key1, this.value1).doubleIterator();
    }

    public void forEach(DoubleProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(DoublePredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public double sum()
    {
        return this.value1;
    }

    public double min()
    {
        return this.value1;
    }

    public double max()
    {
        return this.value1;
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.value1;
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public double[] toSortedArray()
    {
        return new double[]{this.value1};
    }

    public MutableDoubleList toSortedList()
    {
        return DoubleArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate)
    {
        return predicate.accept(this.value1) ? DoubleArrayList.newListWith(this.value1).toImmutable() : new DoubleArrayList().toImmutable();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate)
    {
        return predicate.accept(this.value1) ? new DoubleArrayList().toImmutable() : DoubleArrayList.newListWith(this.value1).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public double[] toArray()
    {
        return new double[]{this.value1};
    }

    public boolean contains(double value)
    {
        return Double.compare(this.value1, value) == 0;
    }

    public boolean containsAll(double... source)
    {
        for (double value : source)
        {
            if (Double.compare(this.value1, value) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source)
    {
        for (DoubleIterator iterator = source.doubleIterator(); iterator.hasNext(); )
        {
            if (Double.compare(this.value1, iterator.next()) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public MutableDoubleList toList()
    {
        return DoubleArrayList.newListWith(this.value1);
    }

    public MutableDoubleSet toSet()
    {
        return DoubleHashSet.newSetWith(this.value1);
    }

    public MutableDoubleBag toBag()
    {
        return DoubleHashBag.newBagWith(this.value1);
    }

    public LazyDoubleIterable asLazy()
    {
        return new LazyDoubleIterableAdapter(this);
    }

    public ImmutableCharDoubleMap newWithKeyValue(char key, double value)
    {
        return CharDoubleMaps.immutable.withAll(CharDoubleHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableCharDoubleMap newWithoutKey(char key)
    {
        return this.key1 == key ? CharDoubleMaps.immutable.with() : this;
    }

    public ImmutableCharDoubleMap newWithoutAllKeys(CharIterable keys)
    {
        return keys.contains(this.key1) ? CharDoubleMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableCharSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableDoubleCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof CharDoubleMap))
        {
            return false;
        }
        CharDoubleMap map = (CharDoubleMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && Double.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    @Override
    public int hashCode()
    {
        return (int) this.key1 ^ (int) (Double.doubleToLongBits(this.value1) ^ Double.doubleToLongBits(this.value1) >>> 32);
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
