/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableCharIntMapFactory;
import com.gs.collections.api.map.primitive.ImmutableCharIntMap;
import com.gs.collections.api.map.primitive.CharIntMap;

/**
 * ImmutableCharIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharIntMapFactoryImpl implements ImmutableCharIntMapFactory
{
    public ImmutableCharIntMap of()
    {
        return this.with();
    }

    public ImmutableCharIntMap with()
    {
        return ImmutableCharIntEmptyMap.INSTANCE;
    }

    public ImmutableCharIntMap of(char key, int value)
    {
        return this.with(key, value);
    }

    public ImmutableCharIntMap with(char key, int value)
    {
        return new ImmutableCharIntSingletonMap(key, value);
    }

    public ImmutableCharIntMap ofAll(CharIntMap map)
    {
        return this.withAll(map);
    }

    public ImmutableCharIntMap withAll(CharIntMap map)
    {
        if (map instanceof ImmutableCharIntMap)
        {
            return (ImmutableCharIntMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharIntSingletonMap(key, map.get(key));
        }
        return new ImmutableCharIntHashMap(map);
    }
}
