/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableFloatIntMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatIntMap;
import com.gs.collections.api.map.primitive.FloatIntMap;

/**
 * ImmutableFloatIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatIntMapFactoryImpl implements ImmutableFloatIntMapFactory
{
    public ImmutableFloatIntMap of()
    {
        return this.with();
    }

    public ImmutableFloatIntMap with()
    {
        return ImmutableFloatIntEmptyMap.INSTANCE;
    }

    public ImmutableFloatIntMap of(float key, int value)
    {
        return this.with(key, value);
    }

    public ImmutableFloatIntMap with(float key, int value)
    {
        return new ImmutableFloatIntSingletonMap(key, value);
    }

    public ImmutableFloatIntMap ofAll(FloatIntMap map)
    {
        return this.withAll(map);
    }

    public ImmutableFloatIntMap withAll(FloatIntMap map)
    {
        if (map instanceof ImmutableFloatIntMap)
        {
            return (ImmutableFloatIntMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatIntSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatIntHashMap(map);
    }
}
