/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.factory.map.primitive.ImmutableFloatObjectMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatObjectMap;
import com.gs.collections.api.map.primitive.FloatObjectMap;

/**
 * ImmutableFloatObjectMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatObjectMapFactoryImpl implements ImmutableFloatObjectMapFactory
{
    public <V> ImmutableFloatObjectMap<V> of()
    {
        return this.with();
    }

    public <V> ImmutableFloatObjectMap<V> with()
    {
        return (ImmutableFloatObjectMap<V>) ImmutableFloatObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableFloatObjectMap<V> of(float key, V value)
    {
        return this.with(key, value);
    }

    public <V> ImmutableFloatObjectMap<V> with(float key, V value)
    {
        return new ImmutableFloatObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableFloatObjectMap<V> ofAll(FloatObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> ImmutableFloatObjectMap<V> withAll(FloatObjectMap<? extends V> map)
    {
        if (map instanceof ImmutableFloatObjectMap)
        {
            return (ImmutableFloatObjectMap<V>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final float[] array = new float[1];
            map.forEachKey(new FloatProcedure()
            {
                public void value(float each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableFloatObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableFloatObjectHashMap<V>(map);
    }
}
