/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatShortProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.FloatShortMap;
import com.gs.collections.api.map.primitive.ImmutableFloatShortMap;
import com.gs.collections.api.map.primitive.MutableFloatShortMap;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedFloatShortProcedure;
import com.gs.collections.impl.map.mutable.primitive.FloatShortHashMap;

/**
 * ImmutableFloatShortHashMap is the non-modifiable equivalent of {@link FloatShortHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 * @since 4.0.
 */
final class ImmutableFloatShortHashMap implements ImmutableFloatShortMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatShortMap delegate;

    ImmutableFloatShortHashMap(FloatShortMap delegate)
    {
        this.delegate = new FloatShortHashMap(delegate);
    }

    public short get(float key)
    {
        return this.delegate.get(key);
    }

    public short getIfAbsent(float key, short ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public short getOrThrow(float key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(short value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatShortProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.delegate.keysView();
    }

    public ImmutableFloatShortMap select(FloatShortPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatShortMap reject(FloatShortPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableFloatShortMap toImmutable()
    {
        return this;
    }

    public ShortIterator shortIterator()
    {
        return this.delegate.shortIterator();
    }

    public void forEach(ShortProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(ShortPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableShortCollection select(ShortPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public short max()
    {
        return this.delegate.max();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public short min()
    {
        return this.delegate.min();
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public short[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableShortList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public short[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(short value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(short... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ShortIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableShortList toList()
    {
        return this.delegate.toList();
    }

    public MutableShortSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableShortBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyShortIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableFloatShortMap newWithKeyValue(float key, short value)
    {
        MutableFloatShortMap map = new FloatShortHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatShortMap newWithoutKey(float key)
    {
        MutableFloatShortMap map = new FloatShortHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatShortMap newWithoutAllKeys(FloatIterable keys)
    {
        MutableFloatShortMap map = new FloatShortHashMap(this.size());
        map.putAll(this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableFloatSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableShortCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableFloatShortMapSerializationProxy(this);
    }

    protected static class ImmutableFloatShortMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private FloatShortMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableFloatShortMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableFloatShortMapSerializationProxy(FloatShortMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedFloatShortProcedure()
                {
                    @Override
                    public void safeValue(float key, short value) throws IOException
                    {
                        out.writeFloat(key);
                        out.writeShort(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableFloatShortMap deserializedMap = new FloatShortHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readFloat(), in.readShort());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
