/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableIntByteMapFactory;
import com.gs.collections.api.map.primitive.ImmutableIntByteMap;
import com.gs.collections.api.map.primitive.IntByteMap;

/**
 * ImmutableIntByteMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntByteMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntByteMapFactoryImpl implements ImmutableIntByteMapFactory
{
    public ImmutableIntByteMap of()
    {
        return this.with();
    }

    public ImmutableIntByteMap with()
    {
        return ImmutableIntByteEmptyMap.INSTANCE;
    }

    public ImmutableIntByteMap of(int key, byte value)
    {
        return this.with(key, value);
    }

    public ImmutableIntByteMap with(int key, byte value)
    {
        return new ImmutableIntByteSingletonMap(key, value);
    }

    public ImmutableIntByteMap ofAll(IntByteMap map)
    {
        return this.withAll(map);
    }

    public ImmutableIntByteMap withAll(IntByteMap map)
    {
        if (map instanceof ImmutableIntByteMap)
        {
            return (ImmutableIntByteMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntByteSingletonMap(key, map.get(key));
        }
        return new ImmutableIntByteHashMap(map);
    }
}
