/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.LongCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.LongCharProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.LongCharMap;
import com.gs.collections.api.map.primitive.ImmutableLongCharMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.LongCharMaps;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongCharHashMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;

/**
 * ImmutableLongCharSingletonMap is an optimization for {@link ImmutableLongCharMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableLongCharSingletonMap implements ImmutableLongCharMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\0';
    private final long key1;
    private final char value1;

    ImmutableLongCharSingletonMap(long key1, char value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public char get(long key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public char getIfAbsent(long key, char ifAbsent)
    {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public char getOrThrow(long key)
    {
        if (this.key1 == key)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key)
    {
        return this.key1 == key;
    }

    public boolean containsValue(char value)
    {
        return this.value1 == value;
    }

    public void forEachValue(CharProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(LongProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(LongCharProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyLongIterable keysView()
    {
        return LongCharHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableLongCharMap select(LongCharPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? LongCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new LongCharHashMap().toImmutable();
    }

    public ImmutableLongCharMap reject(LongCharPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new LongCharHashMap().toImmutable()
                : LongCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableLongCharMap toImmutable()
    {
        return this;
    }

    public CharIterator charIterator()
    {
        return LongCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator();
    }

    public void forEach(CharProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum()
    {
        return this.value1;
    }

    public char min()
    {
        return this.value1;
    }

    public char max()
    {
        return this.value1;
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.value1;
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public char[] toSortedArray()
    {
        return new char[]{this.value1};
    }

    public MutableCharList toSortedList()
    {
        return CharArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableCharCollection select(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? CharArrayList.newListWith(this.value1).toImmutable() : new CharArrayList().toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? new CharArrayList().toImmutable() : CharArrayList.newListWith(this.value1).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public char[] toArray()
    {
        return new char[]{this.value1};
    }

    public boolean contains(char value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(char... source)
    {
        for (char value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(CharIterable source)
    {
        for (CharIterator iterator = source.charIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableCharList toList()
    {
        return CharArrayList.newListWith(this.value1);
    }

    public MutableCharSet toSet()
    {
        return CharHashSet.newSetWith(this.value1);
    }

    public MutableCharBag toBag()
    {
        return CharHashBag.newBagWith(this.value1);
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public ImmutableLongCharMap newWithKeyValue(long key, char value)
    {
        return LongCharMaps.immutable.withAll(LongCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableLongCharMap newWithoutKey(long key)
    {
        return this.key1 == key ? LongCharMaps.immutable.with() : this;
    }

    public ImmutableLongCharMap newWithoutAllKeys(LongIterable keys)
    {
        return keys.contains(this.key1) ? LongCharMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableLongSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableCharCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof LongCharMap))
        {
            return false;
        }
        LongCharMap map = (LongCharMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return (int) (this.key1 ^ this.key1 >>> 32) ^ (int) this.value1;
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
