/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableObjectFloatMap;
import com.gs.collections.api.map.primitive.ObjectFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.ObjectFloatMaps;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.mutable.primitive.ObjectFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;

/**
 * ImmutableObjectFloatSingletonMap is an optimization for {@link ImmutableObjectFloatMap} of size 1.
 * This file was automatically generated from template file immutableObjectPrimitiveSingletonMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectFloatSingletonMap<K> extends AbstractImmutableObjectFloatMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;
    private final K key1;
    private final float value1;

    ImmutableObjectFloatSingletonMap(K key1, float value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public FloatIterator floatIterator()
    {
        return ObjectFloatHashMap.newWithKeysValues(this.key1, this.value1).floatIterator();
    }

    public void forEach(FloatProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(FloatPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate)
    {
        return predicate.accept(this.value1) ? FloatLists.immutable.with(this.value1) : FloatLists.immutable.with();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate)
    {
        return predicate.accept(this.value1) ? FloatLists.immutable.with() : FloatLists.immutable.with(this.value1);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public double sum()
    {
        return this.value1;
    }

    public float min()
    {
        return this.value1;
    }

    public float max()
    {
        return this.value1;
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.value1;
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public float[] toSortedArray()
    {
        return new float[]{this.value1};
    }

    public MutableFloatList toSortedList()
    {
        return FloatArrayList.newListWith(this.value1);
    }

    public float[] toArray()
    {
        return new float[]{this.value1};
    }

    public boolean contains(float value)
    {
        return Float.compare(this.value1, value) == 0;
    }

    public boolean containsAll(float... source)
    {
        for (float value : source)
        {
            if (Float.compare(this.value1, value) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(FloatIterable source)
    {
        for (FloatIterator iterator = source.floatIterator(); iterator.hasNext(); )
        {
            if (Float.compare(this.value1, iterator.next()) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public MutableFloatList toList()
    {
        return FloatArrayList.newListWith(this.value1);
    }

    public MutableFloatSet toSet()
    {
        return FloatHashSet.newSetWith(this.value1);
    }

    public MutableFloatBag toBag()
    {
        return FloatHashBag.newBagWith(this.value1);
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public ImmutableObjectFloatMap<K> newWithKeyValue(K key, float value)
    {
        return ObjectFloatMaps.immutable.withAll(ObjectFloatHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectFloatMap<K> newWithoutKey(K key)
    {
        return nullSafeEquals(this.key1, key) ? (ImmutableObjectFloatMap<K>) ImmutableObjectFloatEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other)
    {
        if (value == null)
        {
            if (other == null)
            {
                return true;
            }
        }
        else if (other == value || value.equals(other))
        {
            return true;
        }
        return false;
    }

    public ImmutableObjectFloatMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectFloatHashMap<K> map = new ObjectFloatHashMap<K>(this);
        for (K key : keys)
        {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public float get(Object key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public float getOrThrow(Object key)
    {
        if (nullSafeEquals(this.key1, key))
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public float getIfAbsent(Object key, float ifAbsent)
    {
        return nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key)
    {
        return nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(float value)
    {
        return Float.compare(this.value1, value) == 0;
    }

    public void forEachValue(FloatProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectFloatProcedure<? super K> objectFloatProcedure)
    {
        objectFloatProcedure.value(this.key1, this.value1);
    }

    public ImmutableObjectFloatMap<K> select(ObjectFloatPredicate<? super K> objectFloatPredicate)
    {
        return objectFloatPredicate.accept(this.key1, this.value1) ? ObjectFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : (ImmutableObjectFloatMap<K>) ImmutableObjectFloatEmptyMap.INSTANCE;
    }

    public ImmutableObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> objectFloatPredicate)
    {
        return objectFloatPredicate.accept(this.key1, this.value1) ? (ImmutableObjectFloatMap<K>) ImmutableObjectFloatEmptyMap.INSTANCE
                : ObjectFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectFloatMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public Set<K> keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableFloatCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ObjectFloatMap))
        {
            return false;
        }
        ObjectFloatMap<K> map = (ObjectFloatMap<K>) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && Float.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    @Override
    public int hashCode()
    {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ Float.floatToIntBits(this.value1)  ;
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace()
    {
        return new ImmutableObjectFloatMapSerializationProxy<K>(this);
    }
}
