/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.factory.map.primitive.ImmutableObjectIntMapFactory;
import com.gs.collections.api.map.primitive.ImmutableObjectIntMap;
import com.gs.collections.api.map.primitive.ObjectIntMap;

/**
 * ImmutableObjectIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableObjectIntMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableObjectIntMapFactoryImpl implements ImmutableObjectIntMapFactory
{
    public <K> ImmutableObjectIntMap<K> of()
    {
        return this.with();
    }

    public <K> ImmutableObjectIntMap<K> with()
    {
        return (ImmutableObjectIntMap<K>) ImmutableObjectIntEmptyMap.INSTANCE;
    }

    public <K> ImmutableObjectIntMap<K> of(K key, int value)
    {
        return this.with(key, value);
    }

    public <K> ImmutableObjectIntMap<K> with(K key, int value)
    {
        return new ImmutableObjectIntSingletonMap<K>(key, value);
    }

    public <K> ImmutableObjectIntMap<K> ofAll(ObjectIntMap<? extends K> map)
    {
        return this.withAll(map);
    }

    public <K> ImmutableObjectIntMap<K> withAll(ObjectIntMap<? extends K> map)
    {
        if (map instanceof ImmutableObjectIntMap)
        {
            return (ImmutableObjectIntMap<K>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final Object[] array = new Object[1];
            map.forEachKey(new Procedure<K>()
            {
                public void value(K each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableObjectIntSingletonMap<K>((K) array[0], map.get(array[0]));
        }
        return new ImmutableObjectIntHashMap<K>(map);
    }
}
