/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortFloatMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortFloatMap;
import com.gs.collections.api.map.primitive.ShortFloatMap;

/**
 * ImmutableShortFloatMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortFloatMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortFloatMapFactoryImpl implements ImmutableShortFloatMapFactory
{
    public ImmutableShortFloatMap of()
    {
        return this.with();
    }

    public ImmutableShortFloatMap with()
    {
        return ImmutableShortFloatEmptyMap.INSTANCE;
    }

    public ImmutableShortFloatMap of(short key, float value)
    {
        return this.with(key, value);
    }

    public ImmutableShortFloatMap with(short key, float value)
    {
        return new ImmutableShortFloatSingletonMap(key, value);
    }

    public ImmutableShortFloatMap ofAll(ShortFloatMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortFloatMap withAll(ShortFloatMap map)
    {
        if (map instanceof ImmutableShortFloatMap)
        {
            return (ImmutableShortFloatMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableShortFloatHashMap(map);
    }
}
