/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortIntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ShortIntMap;
import com.gs.collections.api.map.primitive.ImmutableShortIntMap;
import com.gs.collections.api.map.primitive.MutableShortIntMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedShortIntProcedure;
import com.gs.collections.impl.map.mutable.primitive.ShortIntHashMap;

/**
 * ImmutableShortIntHashMap is the non-modifiable equivalent of {@link ShortIntHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 * @since 4.0.
 */
final class ImmutableShortIntHashMap implements ImmutableShortIntMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableShortIntMap delegate;

    ImmutableShortIntHashMap(ShortIntMap delegate)
    {
        this.delegate = new ShortIntHashMap(delegate);
    }

    public int get(short key)
    {
        return this.delegate.get(key);
    }

    public int getIfAbsent(short key, int ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(short key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(short key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(int value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ShortProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ShortIntProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyShortIterable keysView()
    {
        return this.delegate.keysView();
    }

    public ImmutableShortIntMap select(ShortIntPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortIntMap reject(ShortIntPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableShortIntMap toImmutable()
    {
        return this;
    }

    public IntIterator intIterator()
    {
        return this.delegate.intIterator();
    }

    public void forEach(IntProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(IntPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableIntCollection select(IntPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public int max()
    {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int min()
    {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public int[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public int[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(int value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList()
    {
        return this.delegate.toList();
    }

    public MutableIntSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableShortIntMap newWithKeyValue(short key, int value)
    {
        MutableShortIntMap map = new ShortIntHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableShortIntMap newWithoutKey(short key)
    {
        MutableShortIntMap map = new ShortIntHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableShortIntMap newWithoutAllKeys(ShortIterable keys)
    {
        MutableShortIntMap map = new ShortIntHashMap(this.size());
        map.putAll(this);
        ShortIterator iterator = keys.shortIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableShortSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableIntCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableShortIntMapSerializationProxy(this);
    }

    protected static class ImmutableShortIntMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private ShortIntMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableShortIntMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableShortIntMapSerializationProxy(ShortIntMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedShortIntProcedure()
                {
                    @Override
                    public void safeValue(short key, int value) throws IOException
                    {
                        out.writeShort(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableShortIntMap deserializedMap = new ShortIntHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readShort(), in.readInt());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
